/****************************************************************************************/
/*                                                                                      */
/*  Kroenke, Auer, Vandenberg, and Yoder - Database Concepts (8th Edition) Chapter 08   */
/*                                                                                      */
/*  Heather Sweeney Designs Data Warehouse Database Create Tables (SALES_FOR_RFM)                      */
/*                                                                                      */
/*  These are the Oracle Database XE code solutions                              */
/*                                                                                      */
/****************************************************************************************/
 
 
CREATE TABLE SALES_FOR_RFM(
        TimeID              Int                 NOT NULL,
        CustomerID          Int                 NOT NULL,
        InvoiceNumber       Int                 NOT NULL,
        PreTaxTotalSale     Numeric(9,2)        NOT NULL,
        CONSTRAINT          SALES_FOR_RFM_PK
                            PRIMARY KEY (TimeID, CustomerID, InvoiceNumber),
        CONSTRAINT          SRFM_TIMELINE_FK FOREIGN KEY(TimeID)
                                REFERENCES TIMELINE(TimeID),
        CONSTRAINT          SRFM_CUSTOMER_FK FOREIGN KEY(CustomerID)
                                REFERENCES CUSTOMER(CustomerID)
                                 
        );